/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWMilestoneDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.workflow.VWBaseFieldTableModel;
import filenet.vw.toolkit.design.property.workflow.VWTableItemWrapper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.util.Vector;
import javax.swing.Icon;

public class VWMilestonesTableModel
extends VWBaseFieldTableModel {
    private static final int NUM_COLUMNS = 4;
    public static final int COL_SOURCE = 0;
    public static final int COL_NAME = 1;
    public static final int COL_LEVEL = 2;
    public static final int COL_MESSAGE = 3;
    private static final int UPDATE_TYPE_DELETE = 0;
    private static final int UPDATE_TYPE_RENAME = 1;
    private int m_dummyLevel = 1;
    private String m_dummyMessage = VWResource.s_dummyMessage;

    public VWMilestonesTableModel(VWAuthPropertyData authPropertyData) {
        super(authPropertyData);
    }

    public VWMilestoneDefinition getItemAt(int nRowIndex) {
        VWMilestoneDefinition milestoneDef = null;
        VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
        if (wrapper != null && wrapper.getValue() != null) {
            milestoneDef = (VWMilestoneDefinition)wrapper.getValue();
        }
        return milestoneDef;
    }

    public void up(int nRowIndex) {
        try {
            if (nRowIndex != 0) {
                Object currentObj = this.m_rowData.elementAt(nRowIndex);
                Object previousObj = this.m_rowData.elementAt(nRowIndex - 1);
                this.m_rowData.setElementAt(currentObj, nRowIndex - 1);
                this.m_rowData.setElementAt(previousObj, nRowIndex);
                this.updateWorkflowDefinition();
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void down(int nRowIndex) {
        try {
            if (nRowIndex < this.getRowCount() - 2) {
                Object currentObj = this.m_rowData.elementAt(nRowIndex);
                Object previousObj = this.m_rowData.elementAt(nRowIndex + 1);
                this.m_rowData.setElementAt(currentObj, nRowIndex + 1);
                this.m_rowData.setElementAt(previousObj, nRowIndex);
                this.updateWorkflowDefinition();
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void deleteItem(int nRowIndex) {
        block6: {
            try {
                VWMilestoneDefinition milestoneDef;
                if (!this.canDeleteRow(nRowIndex)) {
                    return;
                }
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && wrapper.canDelete() && (milestoneDef = (VWMilestoneDefinition)wrapper.getValue()) != null) {
                    this.m_authPropertyData.getWorkflowDefinition().deleteMilestone(milestoneDef.getName());
                    this.m_authPropertyData.resetMilestoneCache();
                    this.m_authPropertyData.setDirty();
                    if (wrapper.isOverridden()) {
                        wrapper.deleteOverriddenValue();
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    } else {
                        this.m_rowData.removeElementAt(nRowIndex);
                        this.fireTableRowsDeleted(nRowIndex, nRowIndex);
                        this.onRemovedMilestone(milestoneDef.getName());
                        this.m_changedItems = new Vector();
                        this.m_changedItems.addElement(milestoneDef);
                        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 522);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block6;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    public void reinitialize() {
        try {
            this.m_dummyMessage = VWResource.s_dummyMessage;
            this.m_dummyLevel = 1;
            super.reinitialize();
            if (this.m_authPropertyData != null) {
                int i;
                VWMilestoneDefinition[] milestoneDefs;
                if (this.m_authPropertyData.getShowInheritedProperties() && (milestoneDefs = this.m_authPropertyData.getMilestones(2)) != null) {
                    for (i = 0; i < milestoneDefs.length; ++i) {
                        this.m_rowData.addElement(new VWTableItemWrapper(1, milestoneDefs[i]));
                    }
                }
                if ((milestoneDefs = this.m_authPropertyData.getMilestones(1)) != null) {
                    for (i = 0; i < milestoneDefs.length; ++i) {
                        int nIndex = this.findIndex(milestoneDefs[i].getName());
                        if (nIndex != -1) {
                            this.overrideTableItem(nIndex, milestoneDefs[i]);
                            continue;
                        }
                        this.m_rowData.addElement(new VWTableItemWrapper(0, milestoneDefs[i]));
                    }
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int findIndex(String fieldName) {
        int nRowIndex = -1;
        int size = this.m_rowData.size();
        if (size > 0 && fieldName != null && fieldName.length() > 0) {
            for (int i = 0; i < size; ++i) {
                String name;
                VWMilestoneDefinition milestoneDef;
                VWTableItemWrapper wrapper = this.getTableItemAt(i);
                if (wrapper == null || wrapper.getValue() == null || (milestoneDef = (VWMilestoneDefinition)wrapper.getValue()) == null || VWStringUtils.compare(fieldName, name = milestoneDef.getName()) != 0) continue;
                nRowIndex = i;
                break;
            }
        }
        return nRowIndex;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 0: {
                return Icon.class;
            }
            case 1: 
            case 2: 
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 4 - this.m_nColumnIndexOffset;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: {
                return VWResource.s_nameStr;
            }
            case 2: {
                return VWResource.s_levelStr;
            }
            case 3: {
                return VWResource.s_messageStr;
            }
        }
        return null;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        VWMilestoneDefinition milestoneDef = null;
        try {
            VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
            if (wrapper != null && wrapper.getValue() != null) {
                milestoneDef = (VWMilestoneDefinition)wrapper.getValue();
            }
            switch (nColumnIndex + this.m_nColumnIndexOffset) {
                case 0: {
                    if (wrapper == null) break;
                    return wrapper.getStateIcon();
                }
                case 1: {
                    if (milestoneDef == null) break;
                    return milestoneDef.getName();
                }
                case 2: {
                    if (milestoneDef != null) {
                        return Integer.toString(milestoneDef.getLevel());
                    }
                    return Integer.toString(this.m_dummyLevel);
                }
                case 3: {
                    if (milestoneDef != null) {
                        return milestoneDef.getMessage();
                    }
                    return this.m_dummyMessage;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: {
                if (wrapper != null) {
                    return wrapper.isLocal();
                }
                return true;
            }
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            switch (nColumnIndex + this.m_nColumnIndexOffset) {
                case 1: {
                    this.onUpdateMilestoneName(aValue, nRowIndex);
                    break;
                }
                case 2: {
                    this.onUpdateMilestoneLevel(aValue, nRowIndex);
                    break;
                }
                case 3: {
                    this.onUpdateMilestoneMessage(aValue, nRowIndex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateMilestoneName(Object aValue, int nRowIndex) {
        block8: {
            if (this.m_authPropertyData == null) {
                return;
            }
            try {
                String newName;
                if (aValue == null || !(aValue instanceof String) || (newName = (String)aValue).length() <= 0) break block8;
                VWMilestoneDefinition milestoneDef = null;
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && wrapper.getValue() != null) {
                    milestoneDef = (VWMilestoneDefinition)wrapper.getValue();
                }
                if (milestoneDef != null) {
                    String[] milestoneNames = new String[]{milestoneDef.getName(), newName};
                    milestoneDef.setName(newName);
                    this.m_authPropertyData.setDirty();
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    this.m_changedItems = new Vector();
                    this.m_changedItems.addElement(milestoneNames[0]);
                    this.m_changedItems.addElement(milestoneNames[1]);
                    this.onRenamedMilestone(this.m_changedItems);
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 523);
                    break block8;
                }
                if (this.m_authPropertyData.getMilestone(newName) != null) {
                    String message = VWResource.s_milestoneExists.toString(newName);
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), message, 1);
                    return;
                }
                milestoneDef = this.m_authPropertyData.getWorkflowDefinition().createMilestone(newName);
                if (milestoneDef == null) break block8;
                try {
                    milestoneDef.setMessage(this.m_dummyMessage);
                    milestoneDef.setLevel(this.m_dummyLevel);
                }
                catch (Exception ex) {
                    milestoneDef.setLevel(1);
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
                }
                this.m_rowData.addElement(new VWTableItemWrapper(0, milestoneDef));
                this.m_authPropertyData.resetMilestoneCache();
                this.m_authPropertyData.setDirty();
                this.m_dummyMessage = VWResource.s_dummyMessage;
                this.m_dummyLevel = 1;
                this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(milestoneDef);
                this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 521);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block8;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onUpdateMilestoneLevel(Object aValue, int nRowIndex) {
        if (this.m_authPropertyData == null) {
            return;
        }
        try {
            block11: {
                try {
                    int level;
                    block13: {
                        block15: {
                            VWMilestoneDefinition milestoneDef;
                            block14: {
                                Integer level_num;
                                String newLevel;
                                if (aValue == null || !(aValue instanceof String) || (newLevel = (String)aValue).length() <= 0) break block11;
                                milestoneDef = null;
                                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                                if (wrapper != null && wrapper.getValue() != null) {
                                    milestoneDef = (VWMilestoneDefinition)wrapper.getValue();
                                }
                                if ((level = (level_num = new Integer(newLevel)).intValue()) < 1) {
                                    level = 1;
                                }
                                if (milestoneDef == null) break block13;
                                if (!wrapper.isInherited()) break block14;
                                if (level != milestoneDef.getLevel()) {
                                    VWMilestoneDefinition newMilestoneDef;
                                    block12: {
                                        newMilestoneDef = this.m_authPropertyData.getWorkflowDefinition().createMilestone(milestoneDef.getName());
                                        try {
                                            newMilestoneDef.setMessage(milestoneDef.getMessage());
                                            newMilestoneDef.setLevel(level);
                                        }
                                        catch (Exception ex) {
                                            newMilestoneDef.setLevel(1);
                                            VWDebug.logException(ex);
                                            if (this.m_authPropertyData == null) break block12;
                                            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
                                        }
                                    }
                                    wrapper.overrideValue(newMilestoneDef);
                                }
                                break block15;
                            }
                            milestoneDef.setLevel(level);
                        }
                        this.m_authPropertyData.setDirty();
                        break block11;
                    }
                    this.m_dummyLevel = level;
                }
                catch (Exception ex) {
                    if (this.m_authPropertyData != null && !(ex instanceof NumberFormatException)) {
                        VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
                    }
                    Object var11_12 = null;
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    return;
                }
            }
            Object var11_11 = null;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            return;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onUpdateMilestoneMessage(Object aValue, int nRowIndex) {
        if (this.m_authPropertyData == null) {
            return;
        }
        try {
            block11: {
                try {
                    String newMessage;
                    block13: {
                        block15: {
                            VWMilestoneDefinition milestoneDef;
                            block14: {
                                if (aValue == null || !(aValue instanceof String)) break block11;
                                newMessage = (String)aValue;
                                if (newMessage == null || newMessage.length() == 0) {
                                    newMessage = VWResource.s_dummyMessage;
                                }
                                milestoneDef = null;
                                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                                if (wrapper != null && wrapper.getValue() != null) {
                                    milestoneDef = (VWMilestoneDefinition)wrapper.getValue();
                                }
                                if (milestoneDef == null) break block13;
                                if (!wrapper.isInherited()) break block14;
                                if (VWStringUtils.compare(newMessage, milestoneDef.getMessage()) != 0) {
                                    VWMilestoneDefinition newMilestoneDef;
                                    block12: {
                                        newMilestoneDef = this.m_authPropertyData.getWorkflowDefinition().createMilestone(milestoneDef.getName());
                                        try {
                                            newMilestoneDef.setMessage(newMessage);
                                            newMilestoneDef.setLevel(milestoneDef.getLevel());
                                        }
                                        catch (Exception ex) {
                                            newMilestoneDef.setLevel(1);
                                            VWDebug.logException(ex);
                                            if (this.m_authPropertyData == null) break block12;
                                            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
                                        }
                                    }
                                    wrapper.overrideValue(newMilestoneDef);
                                }
                                break block15;
                            }
                            milestoneDef.setMessage(newMessage);
                        }
                        this.m_authPropertyData.setDirty();
                        break block11;
                    }
                    this.m_dummyMessage = newMessage;
                }
                catch (Exception ex) {
                    if (this.m_authPropertyData != null) {
                        VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
                    }
                    Object var9_10 = null;
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    return;
                }
            }
            Object var9_9 = null;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            throw throwable;
        }
    }

    private void updateWorkflowDefinition() {
        if (this.m_authPropertyData == null) {
            return;
        }
        try {
            VWWorkflowDefinition wfDefinition = this.m_authPropertyData.getWorkflowDefinition();
            if (wfDefinition != null) {
                VWMilestoneDefinition[] milestoneDefs = new VWMilestoneDefinition[this.m_rowData.size()];
                for (int nIndex = 0; nIndex < milestoneDefs.length; ++nIndex) {
                    VWTableItemWrapper tempWrapper = (VWTableItemWrapper)this.m_rowData.elementAt(nIndex);
                    if (tempWrapper == null) continue;
                    milestoneDefs[nIndex] = (VWMilestoneDefinition)tempWrapper.getValue();
                }
                wfDefinition.setMilestones(milestoneDefs);
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onRenamedMilestone(Vector items) {
        try {
            Object obj1 = items.elementAt(0);
            Object obj2 = items.elementAt(1);
            if (this.m_authPropertyData == null || obj1 == null || obj2 == null || !(obj1 instanceof String) || !(obj2 instanceof String)) {
                return;
            }
            this.updateStepMilestones((String)obj1, (String)obj2, 1);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onRemovedMilestone(String milestoneName) {
        try {
            if (this.m_authPropertyData == null || milestoneName == null) {
                return;
            }
            this.updateStepMilestones(milestoneName, null, 0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateStepMilestones(String milestoneName, String newMilestoneName, int nType) {
        try {
            if (this.m_authPropertyData == null || milestoneName == null) {
                return;
            }
            VWWorkflowDefinition wfDefinition = this.m_authPropertyData.getWorkflowDefinition();
            if (wfDefinition == null) {
                return;
            }
            VWMapDefinition[] maps = wfDefinition.getMaps();
            if (maps == null) {
                return;
            }
            for (int i = 0; i < maps.length; ++i) {
                VWMapDefinition map = maps[i];
                VWMapNode[] mapNodes = map.getSteps();
                if (mapNodes == null) continue;
                block7: for (int j = 0; j < mapNodes.length; ++j) {
                    VWMapNode mapNode = mapNodes[j];
                    if (!(mapNode instanceof VWStepDefinition)) continue;
                    switch (nType) {
                        case 0: {
                            newMilestoneName = null;
                            break;
                        }
                        case 1: {
                            if (newMilestoneName == null) continue block7;
                        }
                    }
                    VWStepDefinition stepDef = (VWStepDefinition)mapNode;
                    String preMilestoneName = stepDef.getPreMilestone();
                    String postMilestoneName = stepDef.getPostMilestone();
                    if (preMilestoneName != null && VWStringUtils.compare(preMilestoneName, milestoneName) == 0) {
                        stepDef.setPreMilestone(newMilestoneName);
                    }
                    if (postMilestoneName == null || VWStringUtils.compare(postMilestoneName, milestoneName) != 0) continue;
                    stepDef.setPostMilestone(newMilestoneName);
                }
            }
            return;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

